/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xasm;

import uk.co.demon.obelisk.xasm.ErrorHandler;
import uk.co.demon.obelisk.xasm.MemoryModel;
import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Module;
import uk.co.demon.obelisk.xobj.Section;

public class MemoryModelByte
extends MemoryModel {
    protected byte[] bytes = new byte[9];

    public MemoryModelByte(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    public int getByte(int index) {
        return this.bytes[index];
    }

    public void addByte(Module module, Section section, Expr expr) {
        if (expr.isRelative()) {
            if (section != null) {
                section.addByte(expr);
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = 0;
                }
            } else {
                this.error("No active section");
            }
        } else {
            this.addByte(module, section, expr.resolve(null, null));
        }
    }

    public void addWord(Module module, Section section, Expr expr) {
        if (expr.isRelative()) {
            if (section != null) {
                section.addWord(expr);
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = 0;
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = 0;
                }
            } else {
                this.error("No active section");
            }
        } else {
            this.addWord(module, section, expr.resolve(null, null));
        }
    }

    public void addLong(Module module, Section section, Expr expr) {
        if (expr.isRelative()) {
            if (section != null) {
                section.addLong(expr);
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = 0;
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = 0;
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = 0;
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = 0;
                }
            } else {
                this.error("No active section");
            }
        } else {
            this.addLong(module, section, expr.resolve(null, null));
        }
    }

    public void addByte(Module module, Section section, long value) {
        if (section != null) {
            section.addByte(value);
            if (this.byteCount < this.bytes.length) {
                this.bytes[this.byteCount++] = (byte)(value & 0xFFL);
            }
        } else {
            this.error("No active section");
        }
    }

    public void addWord(Module module, Section section, long value) {
        if (section != null) {
            section.addWord(value);
            if (module.isBigEndian()) {
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 8 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 0 & 0xFFL);
                }
            } else {
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 0 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 8 & 0xFFL);
                }
            }
        } else {
            this.error("No active section");
        }
    }

    public void addLong(Module module, Section section, long value) {
        if (section != null) {
            section.addLong(value);
            if (module.isBigEndian()) {
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 24 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 16 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 8 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 0 & 0xFFL);
                }
            } else {
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 0 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 8 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 16 & 0xFFL);
                }
                if (this.byteCount < this.bytes.length) {
                    this.bytes[this.byteCount++] = (byte)(value >> 24 & 0xFFL);
                }
            }
        } else {
            this.error("No active section");
        }
    }
}

